<?php

$pageContent = new HudsonEdgeAdminPage(
	"_content",
	esc_html__( "Content", 'hudson' ),
	"fa fa-align-justify"
);
$hudson_edge_framework->edgtOptions->addAdminPage(
	"page_content",
	$pageContent
);

$panelGeneral = new HudsonEdgePanel(
	esc_html__( "General Settings", 'hudson' ),
	"panel_general"
);
$pageContent->addChild(
	"panel_general",
	$panelGeneral
);

$background_color = new HudsonEdgeField(
	"color",
	"background_color",
	"",
	esc_html__( "Content Background Color", 'hudson' ),
	esc_html__( "Choose the background color for page content area. Default color is #f5f5f5.", 'hudson' )
);
$panelGeneral->addChild(
	"background_color",
	$background_color
);

$background_color_grid = new HudsonEdgeField(
	"color",
	"background_color_grid",
	"",
	esc_html__( "Content Background Color for Templates in Grid", 'hudson' ),
	esc_html__( "Choose the background color for the page templates in grid.", 'hudson' )
);
$panelGeneral->addChild(
	"background_color_grid",
	$background_color_grid
);

$content_top_padding = new HudsonEdgeField(
	"text",
	"content_top_padding",
	"0",
	esc_html__( "Content Top Padding (px)", 'hudson' ),
	esc_html__( "Enter top padding for content area. If you set this value then it's important to set also Content top padding for mobile header value.", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panelGeneral->addChild(
	"content_top_padding",
	$content_top_padding
);

$content_top_padding_default_template = new HudsonEdgeField(
	"text",
	"content_top_padding_default_template",
	"44",
	esc_html__( "Content Top Padding for Templates in Grid (px)", 'hudson' ),
	esc_html__( "Enter top padding for content area for Templates in grid. If you set this value then it's important to set also Content top padding for mobile header value.", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panelGeneral->addChild(
	"content_top_padding_default_template",
	$content_top_padding_default_template
);

$content_top_padding_mobile = new HudsonEdgeField(
	"text",
	"content_top_padding_mobile",
	"44",
	esc_html__( "Content Top Padding for Mobile Header (px)", 'hudson' ),
	esc_html__( "Enter top padding for content area for Mobile Header.", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panelGeneral->addChild(
	"content_top_padding_mobile",
	$content_top_padding_mobile
);

$overlapping_content = new HudsonEdgeField(
	"yesno",
	"overlapping_content",
	"no",
	esc_html__( "Enable Overlapping Content", 'hudson' ),
	esc_html__( "Enabling this option will make content overlap title area or slider for set amount of pixels", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_overlapping_content_container"
	)
);
$panelGeneral->addChild(
	"overlapping_content",
	$overlapping_content
);

$overlapping_content_container = new HudsonEdgeContainer(
	"overlapping_content_container",
	"overlapping_content",
	"no"
);
$panelGeneral->addChild(
	"overlapping_content_container",
	$overlapping_content_container
);

$overlapping_top_content_amount = new HudsonEdgeField(
	"text",
	"overlapping_top_content_amount",
	"",
	esc_html__( "Overlapping top amount (px)", 'hudson' ),
	esc_html__( "Enter amount of pixels you would like content to overlap title area or slider (default is 40)", 'hudson' ),
	array(),
	array( "col_width" => 1 )
);
$overlapping_content_container->addChild(
	"overlapping_top_content_amount",
	$overlapping_top_content_amount
);

$overlapping_bottom_content_amount = new HudsonEdgeField(
	"text",
	"overlapping_bottom_content_amount",
	"",
	esc_html__( "Overlapping bottom amount (px)", 'hudson' ),
	esc_html__( "Enter amount of pixels you would like content to overlap footer (default is 40)", 'hudson' ),
	array(),
	array( "col_width" => 1 )
);
$overlapping_content_container->addChild(
	"overlapping_bottom_content_amount",
	$overlapping_bottom_content_amount
);

$overlapping_content_padding = new HudsonEdgeField(
	"text",
	"overlapping_content_padding",
	"",
	esc_html__( "Overlapping left/right padding (px)", 'hudson' ),
	esc_html__( "This option takes effect only on Default (in grid) templates", 'hudson' ),
	array(),
	array( "col_width" => 1 )
);
$overlapping_content_container->addChild(
	"overlapping_content_padding",
	$overlapping_content_padding
);

$animate_overlapping_content = new HudsonEdgeField(
	"yesno",
	"animate_overlapping_content",
	"no",
	esc_html__( "Animate overlapping content", 'hudson' ),
	esc_html__( "Enabling this option will turn on entry animation on overlapping content", 'hudson' )
);
$overlapping_content_container->addChild(
	"animate_overlapping_content",
	$animate_overlapping_content
);

$frame_around_overlapping_content = new HudsonEdgeField(
	"yesno",
	"frame_around_overlapping_content",
	"no",
	esc_html__( "Frame around overlapping content", 'hudson' ),
	esc_html__( "Enabling this option will set a frame around the overlapping content", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_frame_around_overlapping_content_container"
	)
);
$overlapping_content_container->addChild(
	"frame_around_overlapping_content",
	$frame_around_overlapping_content
);

$frame_around_overlapping_content_container = new HudsonEdgeContainer(
	"frame_around_overlapping_content_container",
	"frame_around_overlapping_content",
	"no"
);
$overlapping_content_container->addChild(
	"frame_around_overlapping_content_container",
	$frame_around_overlapping_content_container
);

$frame_around_overlapping_content_width = new HudsonEdgeField(
	"text",
	"frame_around_overlapping_content_width",
	"",
	esc_html__( "Frame width (px)", 'hudson' ),
	esc_html__( "Enter the width of the frame (default is 15)", 'hudson' ),
	array(),
	array( "col_width" => 1 )
);
$frame_around_overlapping_content_container->addChild(
	"frame_around_overlapping_content_width",
	$frame_around_overlapping_content_width
);

$frame_around_overlapping_content_color = new HudsonEdgeField(
	"color",
	"frame_around_overlapping_content_color",
	"",
	esc_html__( "Frame Color", 'hudson' ),
	esc_html__( "Choose a color for frame", 'hudson' )
);
$frame_around_overlapping_content_container->addChild(
	"frame_around_overlapping_content_color",
	$frame_around_overlapping_content_color
);

$frame_around_overlapping_content_pattern = new HudsonEdgeField(
	"image",
	"frame_around_overlapping_content_pattern",
	"",
	esc_html__( "Pattern Image", 'hudson' ),
	esc_html__( "Choose an image to be used as a pattern in the frame around the overlapping content", 'hudson' )
);
$frame_around_overlapping_content_container->addChild(
	"frame_around_overlapping_content_pattern",
	$frame_around_overlapping_content_pattern
);

$content_grid_position = new HudsonEdgeField(
	"select",
	"content_grid_position",
	"",
	esc_html__( "Position of Content in Grid", 'hudson' ),
	esc_html__( "Set position of content in grid", 'hudson' ),
	array(
		"default" => esc_html__( "Default", 'hudson' ),
		"left" => esc_html__( "Left", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$panelGeneral->addChild(
	"content_grid_position",
	$content_grid_position
);

$content_predefined_width = new HudsonEdgeField(
	"select",
	"content_predefined_width",
	"",
	esc_html__( "Initial Width of Content", 'hudson' ),
	esc_html__( "Choose the initial width of content which is in grid (Applies to pages set to 'Default Template' and rows set to 'In Grid' )", 'hudson' ),
	array(
		"" => esc_html__( "1100px - default", 'hudson' ),
		"grid_1300" => esc_html__( "1300px", 'hudson' ),
		"grid_1200" => esc_html__( "1200px", 'hudson' ),
		"grid_1000" => esc_html__( "1000px", 'hudson' ),
		"grid_800" => esc_html__( "800px", 'hudson' )
	)
);
$panelGeneral->addChild(
	"content_predefined_width",
	$content_predefined_width
);

//Content Bottom
$panelContentBottom = new HudsonEdgePanel(
	esc_html__( "Content Bottom Area", 'hudson' ),
	"content_bottom_area_panel"
);
$pageContent->addChild(
	"panel_content_bottom",
	$panelContentBottom
);

$enable_content_bottom_area = new HudsonEdgeField(
	"yesno",
	"enable_content_bottom_area",
	"no",
	esc_html__( "Enable Content Bottom Area", 'hudson' ),
	esc_html__( "This option will enable Content Bottom area on pages", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_content_bottom_area_container"
	)
);
$panelContentBottom->addChild(
	"enable_content_bottom_area",
	$enable_content_bottom_area
);

$enable_content_bottom_area_container = new HudsonEdgeContainer(
	"enable_content_bottom_area_container",
	"enable_content_bottom_area",
	"no"
);
$panelContentBottom->addChild(
	"enable_content_bottom_area_container",
	$enable_content_bottom_area_container
);

$custom_sidebars = hudson_edge_get_custom_sidebars();

$content_bottom_sidebar_custom_display = new HudsonEdgeField(
	"selectblank",
	"content_bottom_sidebar_custom_display",
	"",
	esc_html__( "Sidebar to Display", 'hudson' ),
	esc_html__( "Choose a Content Bottom sidebar to display", 'hudson' ),
	$custom_sidebars
);
$enable_content_bottom_area_container->addChild(
	"content_bottom_sidebar_custom_display",
	$content_bottom_sidebar_custom_display
);

$content_bottom_in_grid = new HudsonEdgeField(
	"yesno",
	"content_bottom_in_grid",
	"yes",
	esc_html__( "Display in Grid", 'hudson' ),
	esc_html__( "Enabling this option will place Content Bottom in grid", 'hudson' )
);
$enable_content_bottom_area_container->addChild(
	"content_bottom_in_grid",
	$content_bottom_in_grid
);

$content_bottom_background_color = new HudsonEdgeField(
	"color",
	"content_bottom_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose a background color for Content Bottom area", 'hudson' )
);
$enable_content_bottom_area_container->addChild(
	"content_bottom_background_color",
	$content_bottom_background_color
);
